<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Ad extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;
    protected $fillable = array('title', 'desc', 'user_id', 'size', 'ad_type_id', 'ad_status_id', 'price', 'city_id', 'category_id');

    public function type()
    {
        return $this->belongsTo('AdType', 'ad_type_id');
    }

    public function status()
    {
        return $this->belongsTo('AdStatus', 'ad_status_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function photos()
    {
        return $this->hasMany('Photo', 'ad_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}